/*
 * Decompiled with CFR 0.152.
 */
package levosilimo.everlastingskins.mixin.server;

import com.mojang.authlib.properties.Property;
import java.util.List;
import levosilimo.everlastingskins.skinchanger.MojangSkinProvider;
import levosilimo.everlastingskins.skinchanger.SkinRestorer;
import levosilimo.everlastingskins.skinchanger.SkinStorage;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public abstract class MixinPlayerManager {
    private static void applySkin(ServerPlayer playerEntity, Property skin) {
        playerEntity.m_36316_().getProperties().removeAll((Object)"textures");
        playerEntity.m_36316_().getProperties().put((Object)"textures", (Object)skin);
    }

    @Shadow
    public abstract List<ServerPlayer> m_11314_();

    @Inject(method={"placeNewPlayer"}, at={@At(value="HEAD")})
    private void onPlayerConnect(Connection mutablecomponent, ServerPlayer player, CallbackInfo ci) {
        if (SkinRestorer.getSkinStorage().getSkin(player.m_20148_()) == SkinStorage.DEFAULT_SKIN) {
            SkinRestorer.getSkinStorage().setSkin(player.m_20148_(), MojangSkinProvider.getSkin(player.m_36316_().getName()));
        }
        MixinPlayerManager.applySkin(player, SkinRestorer.getSkinStorage().getSkin(player.m_20148_()));
    }

    @Inject(method={"remove"}, at={@At(value="TAIL")})
    private void remove(ServerPlayer player, CallbackInfo ci) {
        SkinRestorer.getSkinStorage().removeSkin(player.m_20148_());
    }

    @Inject(method={"removeAll"}, at={@At(value="HEAD")})
    private void disconnectAllPlayers(CallbackInfo ci) {
        for (ServerPlayer player : this.m_11314_()) {
            SkinRestorer.getSkinStorage().removeSkin(player.m_20148_());
        }
    }
}

